\name{NCA-package}
\alias{NCA-package}
\alias{NCA}
\docType{package}
\title{Necessary Condition Analysis}
\description{The NCA package implements Necessary Condition Analysis (NCA) as developed by Dul (2015). For running the NCA package a data file (e.g., mydata.csv, which contains the input data) must be available. An example data file (presented in above paper) is included in the package. The user must load the data and call the nca function. The call must be accompanied with parameters to fit the software to the specific situation.}
\details{\tabular{ll}{
    Package: \tab NCA\cr
    Type: \tab Package\cr
    Version: \tab 1.1\cr
    Date: \tab 2015-10-09\cr
    License: \tab GPL (>= 3)\cr}
}
\author{
Author: Jan Dul \email{jdul@rsm.nl}\cr
Maintainer: Govert Buijs \email{buijs@rsm.nl}
}

\references{
Dul, J. 2015. Necessary Condition Analysis (NCA).
\dQuote{Logic and Methodology of 'Necessary but not Sufficient' causality.}
This paper is published in Organizational Research Methods (Sage publishers)\cr
http://dx.doi.org/10.2139/ssrn.2588480). 

}

\keyword{package}

\examples{
  # A more detailed guide can be found here : http://ssrn.com/abstract=2624981

  # Load data from a CSV file with header and row names:
  \donttest{\dontshow{try(}data <- read.csv("mydata.csv", row.names=1)\dontshow{, silent=TRUE)}}
  # Or load the example dataset
  data(nca.example)
  data <- nca.example

  # Run NCA with the dataset
  # Specify the number of independent and dependent variables
  nca(data, 2, 1)

  # For using the numerical output of the analysis, suppress the output windows
  output <- nca(data, 2, 1, invisible=TRUE)
  # output has 3 matrices : loopdatas (nx x ny), values (nx x ny) and the bottlenecks (1 x ny)
  names(output)

  # The first matrix is loopdatas, and contains relevant data specific for a nx-ny
  # combination, things like names, low/high values and the size of the scope
  output$loopdatas[[2,1]]

  # The second matrix is values, with in each cell a list for the results of the methods
  names(output$values[[1, 1]])
  # Each method result is a list of things like ceiling, slope/intercept etc.
  names(output$values[[2, 1]]$cr_fdh)
  # It also contains the inefficiencies
  output$values[[2, 1]]$cr_fdh$ineffs

  # The last matrix contains the bottlenecks, 1 per dependent variable
  output$bottlenecks[[1, 1]]
}
