\name{NCA-package}
\docType{package}
\title{Necessary Condition Analysis}
\description{The NCA package implements Necessary Condition Analysis (NCA) as developed by Dul (2016). For running the NCA package a data file (e.g., mydata.csv, which contains the input data) must be available. An example data file (presented in above paper) is included in the package. The user must load the data and call the nca function. The call must be accompanied with parameters to fit the software to the specific situation.}
\details{\tabular{ll}{
  Package:  \tab NCA\cr
  Type:     \tab Package\cr
  Version:  \tab 2.0\cr
  Date:     \tab 2016-05-17\cr
  License:  \tab GPL (>= 3)\cr}
}
\author{
Author: Jan Dul \email{jdul@rsm.nl}\cr
Maintainer: Govert Buijs \email{buijs@rsm.nl}
}
\references{
Dul, J. 2016. Necessary Condition Analysis (NCA).
\dQuote{Logic and Methodology of 'Necessary but not Sufficient' causality.}
This paper is published in Organizational Research Methods 19(1), 10-52 (Sage publishers)\cr
\href{http://dx.doi.org/10.2139/ssrn.2588480}{http://dx.doi.org/10.2139/ssrn.2588480}
}

\examples{
  # A more detailed guide can be found here : http://repub.eur.nl/pub/78323/
  # or http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2624981

  # Load data from a CSV file with header and row names:
  \donttest{\dontshow{try(}data <- read.csv("mydata.csv", row.names=1)\dontshow{, silent=TRUE)}}
  # Or load the example dataset
  data(nca.example)
  data <- nca.example

  # Run NCA with the dataset
  # Specify the independent and dependent variables (if more than 1 use a vector)
  model <- nca_analysis(data, c(1, 2), 3)

  # the result is a list of 3 items :
  # - plots (1 for each independent variable)
  # - summaries (1 for each independent variable)
  # - bottlenecks (1 for each ceiling technique)
  names(model)

  # The first item contains the graphical outputs for each independent variable
  # This is not really useful to humans
  model$plots[[1]]

  # The seconds item contains a list with the summaries for the independent variables
  model$summaries[[1]]

  # The third item contains a list with the bottlenecks, one for each ceiling technique
  model$bottlenecks$cr_fdh

  # This shows the summaries in the console (see documentation for more options)
  nca_output(model)
}
\seealso{
  \code{\link{nca_analysis}}, \code{\link{nca_output}}
}
\keyword{package}