% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{list.to.env}
\alias{list.to.env}
\title{Create variables from a list}
\usage{
list.to.env(list)
}
\arguments{
\item{list}{list, with named objects, each element will become a named variable in
the current environment}
}
\value{
New variables will be added to the current environment. Use with care as any
already existing with the same name will be overwritten.
}
\description{
Places named objects in a list into the working environment as individual variables.
Can be particularly helpful when you want to call a function that produces a list of
multiple return variables; this gives a way to access them all at once in the environment
from which the function was called.
}
\examples{
list.to.env(list(myChar="a string", myNum=1234, myList=list("list within a list",c(1,2,3))))
print(myChar)
print(myNum)
print(myList)
two.arg.return <- function(X) { return(list(Y=X+1,Z=X*10)) }
result <- two.arg.return(11) # function returns list with 2 variables
list.to.env(result)
print(Y); print(Z)
}
\seealso{
base::list2env
}

