% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nea-render.r
\name{nea.render}
\alias{nea.render}
\title{Network Enrichment Analysis (NEA)}
\usage{
nea.render(AGS, FGS, NET, Lowercase = 1, ags.gene.col = 2,
  ags.group.col = 3, fgs.gene.col = 2, fgs.group.col = 3,
  net.gene1.col = 1, net.gene2.col = 2, echo = 1, graph = FALSE,
  na.replace = 0, Parallelize = 1)
}
\arguments{
\item{AGS}{Either a text file or a list of members of each AGS (see Details). Group IDs should be found in \code{ags.group.col} and gene IDs should be found in \code{ags.gene.col}. As a special option, an AGS list for can also be pre-created from raw data matrices of the format "genes X samples". Such matrices can contain information on gene copy number, gene/protein expression, gene methylation etc.  (\code{\link{samples2ags}}) or point mutation data (\code{\link{mutations2ags}}). These two functions return AGS lists of length=ncol(Nsamples).}

\item{FGS}{Either a text file or a list of members of each FGS (see Details). Group IDs should be found in \code{fgs.group.col} and gene IDs would be found in \code{fgs.gene.col}. As an  alternative, this function can use  single-node FGSs from the network nodes, which should be pre-created with \code{\link{as_genes_fgs}}). In this case each network node X becomes an FGS on its own. Respective names in the FGS list equal 'X' and the content becomes c('X'). The total length of the FGS list then equals no. of nodes in the network. If fewer nodes are needed for such single-node analysis, then one can submit a text file with \code{fgs.gene.col} and \code{fgs.group.col} contain identical gene IDs. This option uses \code{\link{as_genes_fgs}}.}

\item{NET}{The global network for the analysis (see Details) .}

\item{Lowercase}{render node and group IDs lower-case (Default:1, i.e. 'yes').}

\item{ags.gene.col}{number of the column containing AGS genes (only needed if AGS is submitted as a text file).}

\item{ags.group.col}{number of the column containing group IDs (only needed if AGS is submitted as a text file).}

\item{fgs.gene.col}{number of the column containing FGS genes (only needed if FGS is submitted as a text file).}

\item{fgs.group.col}{number of the column containing group IDs (only needed if FGS is submitted as a text file).}

\item{net.gene1.col}{number of the column containing first nodes of each network edge (only needed if NET is submitted as a text file).}

\item{net.gene2.col}{number of the column containing second nodes of each network edge (only needed if NET is submitted as a text file).}

\item{echo}{if messages about execution progress should appear.}

\item{graph}{Plot the heat map}

\item{na.replace}{replace NA values. Default=0, i.e. not to replace}

\item{Parallelize}{The number of CPU cores to be used for the step "Counting actual links" (the other steps are sufficiently fast). The option is not supported on Windows.}
}
\value{
An object, i.e. a list of elements \code{n.actual}, \code{n.expected}, \code{chi}, \code{z}, \code{p}, \code{q}, each of which is a matrix of size \code{length(FGS)} x \code{length(AGS)}. The two former ones contain the numbers of network edges between any nodes of AGS and any nodes of FGS, respectively those observed in the actual network and expected by chance. \code{chi} are the original chi-squared network enrichment statistic values. \code{z} are respective z-scores which are normally distributed under null and are thus suitable as input to regression modelling and other parametric methods. \code{p} and \code{q} are p-values and respective FDR estimates from \code{p.adjust(p, method="BH")}.
}
\description{
Given the altered gene sets (AGS), functional gene sets (FGS) and the network, calculates no. of edges (network links) that connect individual genes in each AGS-FGS pair (edges confined within AGS only or FGS only are not counted). Returns relevant statistics in matrices of size \code{length(FGS)} x \code{length(AGS)} (see "Value"). Each of the first three parameters can be submitted as either a text file or as a list which has been preloaded with \code{\link{import.gs}} and \code{\link{import.net}}. The latter scenario could save much (see Details).
}
\details{
both AGS and FGS can be either 1) a list preloaded from a text file using e.g. GS=import.gs("text_file.groups"); names of the list entries are sample (column) IDs and the entries contain gene/protein IDs that characterize each sample or 2) name of the file "text_file.groups" to be read from the disk using \code{\link{import.gs}}. The TAB-delimited file "text_file.groups" should contain pre-compiled gene sets, so that gene set IDs will be found in column \code{ags.group.col} / \code{fgs.group.col} and gene IDs will be found in \code{ags.gene.col} / \code{fgs.gene.col}. Option (1) is much more efficient than (2) when \code{\link{nea.render}} has to be run multiple times. Similarly to AGS and FGS, NET could be submitted as either a list, pre-loaded with \code{\link{import.net}}, or a text TAB-delimited file where two columns \code{net.gene1.col} and \code{net.gene2.col} represent nodes of respective edges.
}
\examples{
ags.list <- samples2ags(fantom5.43samples, Ntop=20, method="topnorm")
data(can.sig.go)
fpath <- can.sig.go
fgs.list <- import.gs(fpath)
summary(fgs.list)
data(net.kegg)
netpath <- net.kegg
net <- import.net(netpath)
n1 <- nea.render(AGS=ags.list[1:10], FGS=fgs.list[1:10], NET=net, graph=FALSE)
hist(n1$chi, breaks=100)
hist(n1$z, breaks=100)
hist(n1$p, breaks=100)
hist(n1$q, breaks=100)
}
\references{
\url{http://www.biomedcentral.com/1471-2105/13/226}
}
\seealso{
\code{\link{samples2ags}}
}
\keyword{AGS}
\keyword{FGS}

