% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea-render.r
\name{gsea.render}
\alias{gsea.render}
\title{Gene Set Enrichment Analysis (GSEA)}
\usage{
gsea.render(AGS, FGS, Lowercase = 1, ags.gene.col = 2, ags.group.col = 3,
  fgs.gene.col = 2, fgs.group.col = 3, echo = 1, Ntotal = 20000,
  Parallelize = 1)
}
\arguments{
\item{AGS}{Either a text file or a list of members of each AGS (see Details). Group IDs should be found in \code{ags.group.col} and gene IDs would be found in \code{ags.gene.col}. Identical to AGS needed for in \code{\link{nea.render}} - see also details there.}

\item{FGS}{Either a text file or a list of members of each FGS (see Details). Group IDs should be found in \code{fgs.group.col} and gene IDs would be found in \code{fgs.gene.col}. Alsmost identical to FGS needed for in \code{\link{nea.render}}.}

\item{Lowercase}{render node and group IDs lower-case (Default:1, i.e. 'yes').}

\item{ags.gene.col}{number of the column containing AGS genes (only needed if AGS is submitted as a text file).}

\item{ags.group.col}{number of the column containing group IDs (only needed if AGS is submitted as a text file).}

\item{fgs.gene.col}{number of the column containing FGS genes (only needed if FGS is submitted as a text file).}

\item{fgs.group.col}{number of the column containing group IDs (only needed if FGS is submitted as a text file).}

\item{echo}{if messages about execution progress should appear.}

\item{Ntotal}{The important parameter for precise calculation of the Fisher's statistics: how big is the whole gene universe? Defaults to 20000 but should be changed depending on the hypothesis and genome/proteome size.}

\item{Parallelize}{The number of CPU cores to be used for calculating the gene set overlap. The other steps are sufficiently fast. The option is not supported in Windows.}
}
\value{
A list of entries \code{estimate}, \code{p}, \code{q}, and \code{n}, each of which is a matrix of size \code{length(FGS)} x \code{length(AGS)}. The two former ones contain respective output of \code{\link{fisher.test}}: \code{p.value} and \code{estimate}, whereas \code{q} is produced by \code{p.adjust(p.value, method="BH")} and \code{n} is the no. of shared  members. Input to \code{\link{fisher.test}} is \code{matrix(c(<no. of shared  members>, <no. of solely FGS  members>, <no. of solely AGS  members>, <no. of non-members>), nrow=2)}.
}
\description{
A binomial version of GSEA, unified as much as possible with \code{\link{nea.render}}. Given the altered gene sets (AGS) and functional gene sets (FGS), calculates no. of members (genes/protein IDs) shared by each AGS-FGS pair as well as respective enrichment statistics. Returns matrices of size \emph{{length(FGS)} x {length(AGS)}} (see "Value"). Each of these two parameters can be submitted as either a text file or as an R list which have been preloaded with \code{\link{import.gs}}.
}
\examples{
ags.list <- samples2ags(fantom5.43samples, Ntop=20, method="topnorm")
data(can.sig.go)
fpath <- can.sig.go
fgs.list <- import.gs(fpath)
g1 <- gsea.render(AGS=ags.list, FGS=fgs.list, Lowercase = 1, 
ags.gene.col = 2, ags.group.col = 3, fgs.gene.col = 2, fgs.group.col = 3, 
echo=1, Ntotal = 20000, Parallelize=1)
hist(g1$estimate, breaks=100)
hist(g1$n, breaks=100)
hist(g1$p, breaks=100)
hist(g1$q, breaks=100)
}
\seealso{
\code{\link{nea.render}}, \code{\link{import.gs}}
}
\keyword{AGS}
\keyword{FGS}
