% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{NFCP_domains}
\alias{NFCP_domains}
\title{N-Factor MLE search boundaries}
\usage{
NFCP_domains(
  parameters,
  kappa = NULL,
  lambda = NULL,
  sigma = NULL,
  mu = NULL,
  mu_rn = NULL,
  rho = NULL,
  ME = NULL,
  x_0 = NULL,
  E = NULL
)
}
\arguments{
\item{parameters}{a vector of parameter names of an N-factor model. Function \code{NFCP_parameters} is recommended.}

\item{kappa}{A vector of length two specifying the lower and upper bounds for the 'kappa' parameter}

\item{lambda}{A vector of length two specifying the lower and upper bounds for the 'lambda' parameter}

\item{sigma}{A vector of length two specifying the lower and upper bounds for the 'sigma' parameter}

\item{mu}{A vector of length two specifying the lower and upper bounds for the 'mu' parameter}

\item{mu_rn}{A vector of length two specifying the lower and upper bounds for the 'mu_rn' parameter}

\item{rho}{A vector of length two specifying the lower and upper bounds for the 'rho' parameter}

\item{ME}{A vector of length two specifying the lower and upper bounds for the 'ME' (i.e., measurement error) parameter}

\item{x_0}{A vector of length two specifying the lower and upper bounds for the 'x_0' parameter}

\item{E}{A vector of length two specifying the lower and upper bounds for the 'E' parameter}
}
\value{
A matrix of defaulted domains for the given unknown parameters. The first column corresponds to the lower bound of the
allowable search space for the parameter, whilst the second column corresponds to the upper bound. These values were set to allow for the
'realistic' possible values of given parameters as well as restricting some parameters (such as variance and mean-reverting terms) from taking
negative values. The format of the returned matrix matches that required by the \code{Domains} argument of the \code{Genoud} function from the package \code{RGenoud}.
}
\description{
Generate boundaries for the domain of parameters of the N-factor model for parameter estimation.
}
\details{
The \code{NFCP_domains} function generates lower and upper bounds for the parameter estimation procedure in the format required of the 'Domains' argument of the 'genoud' function. \code{NFCP_domains}
allows easy setting of custom boundaries for parameter estimation, whilst also providing default domains of parameters.
}
\examples{
##Specify the Schwartz and Smith (2000) two-factor model
##with fixed measurement error:
parameters_2F <- NFCP_parameters(N_factors = 2,
                                        GBM = TRUE,
                                        initial_states = TRUE,
                                        N_ME = 1)

###Generate the default 'domains' argument of 'NFCP_MLE' function:
NFCP_MLE_bounds <- NFCP_domains(parameters_2F)

}
\references{
Mebane, W. R., and J. S. Sekhon, (2011). Genetic Optimization Using Derivatives: The rgenoud Package for R.
\emph{Journal of Statistical Software}, 42(11), 1-26. URL http://www.jstatsoft.org/v42/i11/.

Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.
}
