% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse-network.R
\name{analyseNetwork}
\alias{analyseNetwork}
\title{Analyze the network (graph)}
\usage{
analyseNetwork(graph)
}
\arguments{
\item{graph}{A igraph graph object.}
}
\value{
A list containing various indicators.
\emph{vertices} is the number of nodes, \emph{edges} is the number of
edges, \emph{general_stats} are other indicators.
}
\description{
This function analyzes the input graph object and returns
several technical indicators.
}
\details{
This function mainly uses several methods in the igraph package to
analyze the input \href{https://igraph.org/r/}{igraph} graph object, and
summarize the indices as a result.
}
\examples{
# generate a graph
g <- igraph::make_graph(c(1, 2, 3, 4, 1, 3), directed = FALSE)
igraph::V(g)$name <- c("n1", "n2", "n3", "n4")

# run analyseNetwork
analyseNetwork(g)
}
\seealso{
\code{\link[igraph]{vcount}}, \code{\link[igraph]{ecount}},
\code{\link[igraph]{edge_density}}, \code{\link[igraph]{count_components}},
\code{\link[igraph]{degree}},\code{\link[igraph]{betweenness}},
\code{\link[igraph]{edge_betweenness}},\code{\link[igraph]{closeness}},
\code{\link[igraph]{eigen_centrality}},\code{\link[igraph]{hub_score}}.
}
