% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadTab.R
\name{NMreadTab}
\alias{NMreadTab}
\title{Read an output table file from NONMEM}
\usage{
NMreadTab(file, tab.count = TRUE, quiet, as.fun, ...)
}
\arguments{
\item{file}{path to NONMEM table file}

\item{tab.count}{Nonmem includes a counter of tables in the
written data files. These are often not useful. However, if
tab.count is TRUE (default), a counter of tables is included
as a column called TABLENO. Just notice, the table numbers in
TABLENO are just cumulatively counting the number of tables
reported in the file. TABLENO is not true to the actual table
number as given by Nonmem.}

\item{quiet}{logical stating whether or not information is
prignted about what is being done. Default can be configured
using NMdataConf.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{...}{Arguments passed to fread.}
}
\value{
The Nonmem table data.
}
\description{
Read a table generated by a $TABLE statement in Nonmem. Generally,
these files cannot be read by read.table or similar because
formatting depends on options in the $TABLE statement, and because
Nonmem sometimes includes extra lines in the output that have to
be filtered out. NMreadTab can do this automatically based on the
table file alone.
}
\details{
The actual reading of data is based on
    data.table::fread. Generally, the function is fast thanks to
    data.table.
}
\seealso{
Other DataRead: 
\code{\link{NMreadCsv}()},
\code{\link{NMscanData}()},
\code{\link{NMscanInput}()},
\code{\link{NMscanTables}()}
}
\concept{DataRead}
