% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm_object.R
\name{nm}
\alias{nm}
\title{Create core NM object}
\usage{
nm(
  run_id = NA_character_,
  run_in = nm_default_dir("models"),
  parent_run_id = NA_character_,
  parent_run_in = NA_character_,
  parent_ctl_name = NA_character_,
  parent_results_dir = NA_character_,
  ctl_name = "run{run_id}.mod",
  type = "execute",
  run_dir = "{run_id}",
  results_dir = nm_default_dir("results"),
  lst_path = "{run_dir}/NM_run1/psn.lst"
)
}
\arguments{
\item{run_id}{Character vector. Run identifier.}

\item{run_in}{Character vector. The location to copy the NONMEM control file
and run location.}

\item{parent_run_id}{Character vector (optional). The run identifier of the
parent run.}

\item{parent_run_in}{Character vector (optional). The location of the parent
run.}

\item{parent_ctl_name}{Character vector (optional). The \code{ctl_name} of the
parent run.}

\item{parent_results_dir}{Character vector (optional). The \code{results_dir} of
the parent run.}

\item{ctl_name}{Character. Name of control file.}

\item{type}{Character (default = \code{"execute"}).  Type of run to run.}

\item{run_dir}{Character (default = \code{"{run_id}"}).  Subdirectory where PsN
will run NONMEM.}

\item{results_dir}{Character (default = \code{"Results"}). Directory to store
results of this run.}

\item{lst_path}{Character (default = \code{"{run_dir}/NM_run1/psn.lst"}) expected
location of .lst file.}
}
\value{
An object of class \code{nm_list}.  Object is concatenatable. Length of
object corresponds to length of \code{run_id}.
}
\description{
Create new nm object. The function \code{\link[=new_nm]{new_nm()}} is more convenient.  This is
mostly a back end function. This is the basic object this package centres
around.  Most package functions act on this object.
}
\examples{

m0 <- nm(run_id = "m0")
m0 ## a human readable representation

## nm objects can be put into tibbles to group runs together
d <- dplyr::tibble(run_id = c("m1", "m2"))
d$m <- nm(d$run_id)
d

}
\keyword{internal}
