% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_iter.R
\name{plot_iter_data}
\alias{plot_iter_data}
\title{Get data for iterations vs parameters/OBJ plots}
\usage{
plot_iter_data(r, trans = TRUE, skip = 0, yvar = "OBJ")
}
\arguments{
\item{r}{An nm object.}

\item{trans}{Logical (default = \code{TRUE}). Should parameter transformations be
performed in accordance with $THETA/$OMEGA/$SIGMA comments}

\item{skip}{Numeric (default = 0). The number of iterations to skip when
plotting.  For observing stationarity it is often useful to remove the
beginning iterations where the OFV and parameters may move a lot.}

\item{yvar}{Character (default = \code{"OBJ"}). Name of variable/parameter to
display.}
}
\value{
Returns \code{data.frame} suitable for use in \code{\link[=plot_iter_ggplot]{plot_iter_ggplot()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Used in shiny app and as a backend function.
}
\seealso{
\code{\link[=plot_iter_ggplot]{plot_iter_ggplot()}}
}
\keyword{internal}
