% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm-gettersetters.R
\name{run_dir_path}
\alias{run_dir_path}
\title{Get path to run_dir}
\usage{
run_dir_path(m)
}
\arguments{
\item{m}{An nm object.}
}
\value{
A path to the \code{run_dir} field of \code{m}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The function \code{\link[=run_dir]{run_dir()}} gives the directory name, whereas this function gets
the (relative) path of \code{\link[=run_dir]{run_dir()}}.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

run_dir_path(m1)
             
}
\seealso{
\code{\link[=nm_getsetters]{nm_getsetters()}}.
}
