% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived-data-prep.R
\name{write_derived_data}
\alias{write_derived_data}
\title{Write derived data file}
\usage{
write_derived_data(d, name, ...)
}
\arguments{
\item{d}{A data.frame. Data frame to be saved.}

\item{name}{Character. Name of file (with or without extension). If not a
path, will save to DerivedData directory.}

\item{...}{Additional arguments to be passed to \code{\link[utils:write.table]{utils::write.csv()}}.}
}
\value{
No return value, called for side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Will write a dataset and an .RDS version of it to the (by default)
"DerivedData" directory.  The main benefit of the .RDS dataset is that
functions like \code{\link[=input_data]{input_data()}} and \code{\link[=output_table]{output_table()}} can
use it for rapid reading speeding up overall function.
}
\details{
If there is no "DerivedData" data directory and you are using a
different structure the argument \code{name} must be a (relative) path to
an existing directory where you want your NONMEM ready dataset to be stored.
}
\examples{

## requires NMproject directory structure to operate in
\dontrun{

## read a dataset that's been copie into SourceData
d <- read.csv("SourceData/orig_data.csv")

## modify it
d <- d[d$ID < 10, ]

d \%>\% write_derived_data("DerivedData/data.csv")

## load it again either with
d <- read_derived_data("data")

## or more commonly if it is associated with run (e.g. m1),
## you can use input_data() to load it via the nm object

d <- input_data(m1)
}
}
\seealso{
\code{\link[=read_derived_data]{read_derived_data()}}, \code{\link[=input_data]{input_data()}}, \code{\link[=exclude_rows]{exclude_rows()}}
}
