% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-run-summaries.R
\name{nm_output_path}
\alias{nm_output_path}
\title{Find an output file associated with a run}
\usage{
nm_output_path(m, extn, file_name)
}
\arguments{
\item{m}{An nm object.}

\item{extn}{Character. Name of extension.}

\item{file_name}{Optional character. Name of file name.}
}
\value{
The path to the relevant output file of \code{m}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is primarily a backend function used to identify output file paths
associated with nm objects.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\% nm_output_path("ext") ## path to ext file

}
