% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-manipulate.R
\name{rename_parameter}
\alias{rename_parameter}
\title{Rename a parameter in NONMEM control stream}
\usage{
rename_parameter(m, ...)
}
\arguments{
\item{m}{An nm object.}

\item{...}{Named arguments with character values indicated old names.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 <- m1 \%>\% rename_parameter(V2 = "V")

m1 \%>\% dollar("PK")
m1 \%>\% dollar("THETA")

}
