% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMupdateSizes.R
\name{NMupdateSizes}
\alias{NMupdateSizes}
\title{Create or update $SIZES in a control stream}
\usage{
NMupdateSizes(
  file.mod = NULL,
  newfile,
  lines = NULL,
  wipe = FALSE,
  write = !is.null(newfile),
  ...
)
}
\arguments{
\item{file.mod}{A path to a control stream. See also alternative
`lines` argument. Notice, if `write` is `TRUE` (default) and
`newfile` is not provided, `file.mod` will be overwritten.}

\item{newfile}{An optional path to write the resulting control
stream to. If nothing is provided, the default is to overwrite
`file.mod`.}

\item{lines}{Control stream lines as a character vector. If you
already read the control stream - say using
`NMdata::NMreadSection()`, use this to modify the text lines.}

\item{wipe}{The default behavior (`wipe=FALSE`) is to add the
`$SIZES` values to any existing values found. If SIZES
parameter names are overlapping with existing, the values will
be updated. If `wipe=TRUE`, any existing `$SIZES` section is
disregarded.}

\item{write}{Write results to `newfile`?}

\item{...}{The $SIZES parameters. Provided anything, like `PD=40`
See examples.}
}
\value{
Character lines with updated control stream
}
\description{
Update $SIZES parameters in a control stream. The control stream
can be in a file or provided as a character vector (file lines).
}
\examples{
## No existing SIZES in control stream
\dontrun{
file.mod <- system.file("examples/nonmem/xgxr032.mod",package="NMsim")
NMupdateSizes(file.mod,LTV=50,write=FALSE)
}
## This controls stream has existing SIZES
\dontrun{
file.mod <- system.file("examples/nonmem/xgxr134.mod",package="NMsim")
NMupdateSizes(file.mod,LTV=50,write=FALSE)
}
## provide control stream as text lines
\dontrun{
file.mod <- system.file("examples/nonmem/xgxr032.mod",package="NMsim")
lines <- readLines(file.mod)
NMupdateSizes(lines=lines,LTV=50,write=FALSE)
}
}
