% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyHelpers.R
\name{overwrite}
\alias{overwrite}
\title{Create function that modifies text elements in a vector}
\usage{
overwrite(..., fixed = TRUE)
}
\arguments{
\item{...}{Passed to `gsub()`}

\item{fixed}{This is passed to gsub(), but `overwrite()`'s default behavior is the opposite of the one of `gsub()`. Default is `FALSE` which means that strings that are exactly matched will be replaced. This is useful because strings like `THETA(1)` contains special characters. Use `fixed=FALSE` to use regular expressions. Also, see other arguments accepted by `gsub()` for advanced features.}
}
\value{
A function that runs `gsub` to character vectors
}
\description{
Create function that modifies text elements in a vector
}
\examples{
myfun <- overwrite("b","d")
myfun(c("a","b","c","abc"))
## regular expressions
myfun2 <- overwrite("b.*","d",fixed=FALSE)
myfun2(c("a","b","c","abc"))
}
