% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMwriteInits.R
\name{NMwriteInits}
\alias{NMwriteInits}
\title{Writes a parameter values to a control stream}
\usage{
NMwriteInits(
  file.mod,
  update = TRUE,
  file.ext = NULL,
  ext,
  values,
  newfile,
  ...
)
}
\arguments{
\item{file.mod}{Path to control stream.}

\item{update}{If `TRUE` (default), the parameter values are
updated based on the `.ext` file.}

\item{file.ext}{Optionally provide the path to an `.ext` file. If
not provided, the default is to replace the file name
extention on `file.mod` with `.ext`. This is only used if
`update=TRUE`.}

\item{values}{A list of lists. Each list specifies a parameter
with named elements. Must be named by the parameter name. ll,
ul and fix can be supplied to modify the parameter. See
examples. Notice, you can use `...` instead. `values` may be easier for programming but other than that, most users will find `...` more intuitive.}

\item{newfile}{If provided, the results are written to this file
as a new input control stream.}

\item{...}{Parameter specifications. See examples,}
}
\value{
a control stream as lines in a character vector.
}
\description{
Edit parameter values, fix/unfix them, or edit lower/upper bounds.
}
\examples{
## Requires NMdata 0.1.9
\dontrun{
file.mod <- system.file("examples/nonmem/xgxr021.mod",package="NMsim") 
NMwriteInits(file.mod,
values=list( "theta(2)"=list(init=1.4),
             "THETA(3)"=list(FIX=1),
             "omega(2,2)"=list(init=0.1))
)
NMwriteInits(file.mod,
  "theta(2)"=list(init=1.4),
  "THETA(3)"=list(FIX=1),
  "omega(2,2)"=list(init=0.1)
)
}
}
\keyword{internal}
