% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPopEtas.R
\name{simPopEtas}
\alias{simPopEtas}
\title{Generate a population based on a Nonmem model}
\usage{
simPopEtas(
  file,
  N,
  seed.R,
  pars,
  file.phi,
  overwrite = FALSE,
  as.fun,
  file.mod,
  seed,
  ...
)
}
\arguments{
\item{file}{Passed to `NMdata::NMreadExt()`. Path to ext file. By
default, `NMreadExt()` uses a`auto.ext=TRUE` which means that
the file name extension is replaced by `.ext`. If your ext
file name extension is not `.ext`, add `auto.ext=FALSE` (see
...).}

\item{N}{Number of subjects to generate}

\item{seed.R}{Optional seed. Will be passed to `set.seed`. Same
thing as running `set.seed` just before calling
`simPopEtas()`.}

\item{pars}{A long-format parameter table containing par.type and
i columns. If this is supplied, the parameter values will not
be read from an ext file, and file has no effect. If an ext
file is available, it is most likely better to use the file
argument.}

\item{file.phi}{An optional phi file to write the generated
subjects to.}

\item{overwrite}{If `file.phi` exists already, overwrite it?
Default is `FALSE`.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{file.mod}{Deprecated. Use file instead.}

\item{seed}{Deprecated. Use seed.R instead.}

\item{...}{Additional arguments passed to NMdata::NMreadExt().}
}
\value{
A data.frame
}
\description{
Generate a population based on a Nonmem model
}
