% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMA.R
\name{NNS.ARMA}
\alias{NNS.ARMA}
\title{NNS ARMA}
\usage{
NNS.ARMA(variable, h = 1, Training.set = NULL, Seasonal.Factor = TRUE,
  Negative.Values = FALSE, Method = "both", Dynamic = FALSE, stn = 0,
  plot = TRUE, Seasonal_plot = TRUE, Intervals = FALSE)
}
\arguments{
\item{variable}{a numeric vector.}

\item{h}{integer; 1 (default) Number of periods to forecast.}

\item{Training.set}{\code{NULL} (defualt) numeric; Sets the number of variable observations \code{(variable[1:Training.set])} to monitor performance of forecast over in-sample range.}

\item{Seasonal.Factor}{logical or integer; \code{TRUE} (default) Automatically selects the best seasonal lag from the seasonality test.  To use weighted average of all seasonal lags set to \code{(Seasonal.Factor=FALSE)}.  Otherwise, directly input known frequency integer lag to use, i.e. \code{(Seasonal.Factor=12)} for monthly data.}

\item{Negative.Values}{logical; \code{FALSE} (default) If the variable can be negative, set to \code{(Negative.Values=TRUE)}.}

\item{Method}{options:("lin","nonlin","both"); To select the regression type of the component series, defaults to \code{(Method="both")} where both linear and nonlinear estimates are generated.  To use a nonlineaer regression, set to \code{(Method="nonlin")}; to use a linear regression set to \code{Method="lin"}.}

\item{Dynamic}{logical; \code{FALSE} (default) To update the seasonal factor with each forecast point, set to \code{(Dynamic=TRUE)}.  The default is \code{(Dynamic=FALSE)} to retain the original seasonal factor from the inputted variable for all ensuing \code{h}.}

\item{stn}{numeric [0,1]; Signal to noise parameter, sets the threshold of \code{(NNS.dep)} which reduces \code{("order")} when \code{(order=NULL)}.  Defaults to \code{(stn=0)} to allow for maximum fit.}

\item{plot}{logical; \code{TRUE} (default) Returns the plot of all periods exhibiting seasonality and the variable level reference in upper panel.  Lower panel returns original data and forecast.}

\item{Seasonal_plot}{logical; \code{TRUE} (default) Adds the seasonality plot above the forecast.  Will be set to \code{FALSE} if no seasonality is detected or \code{Seasonal.Factor} is set to an integer value.}

\item{Intervals}{logical; \code{FALSE} (default) Plots the surrounding forecasts around the final estimate when \code{(Intervals=TRUE)} and \code{(Seasonal.Factor=FALSE)}.  There are no other forecasts to plot when a single \code{Seasonal.Factor} is selected.}
}
\value{
Returns a vector of forecasts of length \code{(h)}.
}
\description{
Autoregressive model incorporating nonlinear regressions of component series.
}
\note{
\code{(Seasonal.Factor=FALSE)} can be a very comutationally expensive exercise due to the number of seasonal periods detected.
}
\examples{
## Nonlinear NNS.ARMA using AirPassengers monthly data and 12 period lag
NNS.ARMA(AirPassengers,h=45,Training.set=100,Seasonal.Factor=12,Method='nonlin')
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{Autoregressive}
\keyword{model}

