% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPM_UPM_VaR.R
\name{LPM.VaR}
\alias{LPM.VaR}
\title{LPM VaR}
\usage{
LPM.VaR(percentile, degree, x)
}
\arguments{
\item{percentile}{numeric [0,1]; The percentile for VaR.}

\item{degree}{integer; \code{(degree=0)} for discrete distributions, \code{(degree=1)} for continuous distributions.}

\item{x}{a numeric vector.}
}
\description{
Generates a VaR based on the Lower Partial Moment ratio
}
\examples{
set.seed(123)
x<-rnorm(100)
LPM.VaR(0.95,0,x)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{VaR}

