% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{LPM.ratio}
\alias{LPM.ratio}
\title{Lower Partial Moment RATIO}
\usage{
LPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically set to mean, but does not have to be. (Vectorized)}

\item{variable}{a numeric vector.}
}
\value{
Standardized LPM of variable
}
\description{
This function generates a standardized univariate lower partial moment for any degree or target.
}
\examples{
set.seed(123)
x<-rnorm(100)
LPM.ratio(0,mean(x),x)

## Continuous CDF
LPM.ratio(1,sort(x),x)


## Joint CDF
\dontrun{
x=rnorm(5000);y=rnorm(5000)
plot3d(x,y,Co.LPM(0,0,sort(x),sort(y),x,y), col='blue', xlab="X", ylab="Y",
zlab="Probability", box=FALSE)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{CDF}
\keyword{continuous}
\keyword{mean,}
\keyword{moments,}
\keyword{partial}
\keyword{variance,}
