% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{DPM_nD}
\alias{DPM_nD}
\title{Divergent Partial Moment nD}
\usage{
DPM_nD(data, target, degree = 0, norm = TRUE)
}
\arguments{
\item{data}{A numeric matrix with observations in rows and variables in columns.}

\item{target}{A numeric vector, length equal to ncol(data).}

\item{degree}{numeric; degree for upper deviations (0 = frequency, 1 = area).}

\item{norm}{logical; if \code{TRUE} (default) normalize to the maximum observed value (→ [0,1]), otherwise return the raw moment.}
}
\value{
Numeric; the n‑dimensional co‑upper partial moment.
}
\description{
This function generates the aggregate n‑dimensional divergent partial moment (n >= 2) for any degree or target.
}
\examples{
\dontrun{
mat <- matrix(rnorm(200), ncol = 4)
DPM_nD(mat, rep(0, ncol(mat)), degree = 1, norm = FALSE)
}
}
