\name{scalestrip}
\alias{scalestrip}
\title{Strips Likert scale point labels, returns numeric or ordinal data}
\usage{
scalestrip(x, ordinal = FALSE)
}
\arguments{
  \item{x}{a \code{\link{vector}}, \code{\link{matrix}}, or
  \code{\link{data.frame}}, containing Likert data labelled
  in the format "Integer - some text", e.g. "10 - Extremely
  Likely"}

  \item{ordinal}{\code{\link{logical}}
  (\code{TRUE}\\code{FALSE}). Should the data returned be
  an ordered factor? Otherwise the data returned is
  \code{\link{numeric}}. Defaults to \code{FALSE}.}
}
\value{
Unlabelled numeric data (by defualt), or an unlabelled
ordered factor (if requested).
}
\description{
Survey systems export responses to Likhert scales with the
scale labels on, meaning that R as factors or text as
opposed to numeric data. This function takes labelled
scales and returns unlabelled numeric data (by default), or
an unlabelled ordered factor (if requested).
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}

