% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Flimited.R
\name{Flimited}
\alias{Flimited}
\title{Compute a limited F-measure}
\usage{
Flimited(n_small_clst, pred, ref)
}
\arguments{
\item{n_small_clst}{an integer for limit size of the small cluster}

\item{pred}{vector of a predicted partition}

\item{ref}{vector of a reference partition}
}
\description{
A limited version of F-measure that only takes into accout small clusters
}
\examples{
pred <- c(rep(1, 5),rep(2, 8),rep(3,10))
ref <- c(rep(1, 5),rep(c(2,3), 4),rep(c(3,2),5))
FmeasureC(pred, ref)
Flimited(6, pred, ref)

}
\references{
Hejblum BP, Alkhassim C, Gottardo R, Caron F, Thiebaut R, Sequential Dirichlet
Process Mixtures of Multivariate Skew t-distributions for Model-based Clustering
of Flow Cytometry Data, in preparation.
}

