% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtpdf.R
\name{mvtpdf}
\alias{mvtpdf}
\title{multivariate Student's t-distribution probability density function}
\usage{
mvtpdf(x, mean, varcovM, df, Log = TRUE)
}
\arguments{
\item{x}{\code{p x n} data matrix with \code{n} the number of observations and
\code{p} the number of dimensions}

\item{mean}{mean vector or list of mean vectors (either a vector,
a matrix or a list)}

\item{varcovM}{variance-covariance matrix or list of variance-covariance
matrices (either a matrix or a list)}

\item{df}{a numeric vector or a list of the degrees of freedom
(either a vector or a list)}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\description{
multivariate Student's t-distribution probability density function
}
\examples{
mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=10000000)
mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1))

mvtpdf(x=matrix(1.96), mean=0, varcovM=diag(1), df=10)

mvtpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
      mean=c(0, 0), varcovM=diag(2), df=10
)

}
