% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NS.test.R
\name{NS.test}
\alias{NS.test}
\title{Parametric bootstrap-based spatial nonstationarity test for Fay-Herroit model}
\usage{
NS.test(formula, vardir, lat, long, iter = 100, data)
}
\arguments{
\item{formula}{an object of class list of formula, describe the model to be fitted}

\item{vardir}{a vector of sampling variances of direct estimators for each small area}

\item{lat}{a vector of latitude for each small area}

\item{long}{a vector of longitude for each small area}

\item{iter}{number of iterations allowed in the algorithm. Default is 100 iterations}

\item{data}{a data frame comprising the variables named in formula and vardir}
}
\value{
The function returns a list with class "htest" containing the following components:
\describe{
  \item{method}{a character string indicating what type of test was performed.}
  \item{p.value}{the p-value for the test.}
  \item{data.name}{a character string giving the name of the data.}
  }
}
\description{
This function performs a parametric bootstrap-based test procudure for testing spatial nonstationarity in the data.
}
\examples{
# Load data set
data(paddysample)
# Testing spatial nonstationarity of the data
result <- NS.test(y ~ x1+x2, var, latitude, longitude, iter=50, data = paddysample[1:10,])
result
}
