\name{NScluster-package}
\alias{NScluster-package}
\alias{NScluster}
\docType{package}

\title{
Simulation and Estimation of the Neyman-Scott Type Spatial Cluster Models
}
\description{
NScluster involves the maximum Palm likelihood estimation procedure for
 Neyman-Scott cluster point process models and their extensions with parallel
 computation using OpenMP technology. The maximum Palm likelihood estimates
 (MPLEs for short) are those that maximize the log-Palm likelihood function.
 The computation of MPLEs is implemented by simplex maximization with parallel
 computation via OpenMP. Together with the likelihood estimation procedure,
 NScluster also provides a simulation procedure for cluster point process
 models.
}
\details{
  The documentation 'A Guide to NScluster: R Package for Maximum Palm Likelihood
  Estimation for Cluster Point Process Models using OpenMP' is available in the
  package vignette using the \code{vignette} function (e.g.,
  \code{vignette("NScluster")}).

  The package NScluster comprises of four tasks:
  simulation, parameter estimation (MPLE), confidence interval estimation, and
  non-parametric and parametric Palm intensity comparison.

  \itemize{
    \item{Simulation:}{

      The \code{\link{sim.cppm}} function simulates the five cluster point 
      process models: the Thomas and Inverse-power type models, and the extended
      Thomas models of type A, B, and C.}
    \item{Parameter estimation (MPLE):}{

      The \code{\link{mple.cppm}} function improves the given initial parameters
      using the simplex method to maximize the log-Palm likelihood function.

      The expensive calculation of the estimation for calculating the parameters
      can be parallelized to reduce calculation time. The package is implemented
      to employ OpenMP, which is a simple framework for shared memory parallel
      computation.} 
    \item{Confidence interval of parameter estimates:}{

      The \code{\link{boot.mple}} function carries out the bootstarp replicates
      for an object generated by \code{\link{mple.cppm}} and computes confidence
      intervals and standard errors.}
    \item{Palm intensity comparison:}{

      The package can depict non-parametric and parametric normalized Palm 
      intensity function of the five cluster point process models using the
      \code{\link{palm.cppm}} function.}
  }
}
\references{
Tanaka, U., Ogata, Y. and Katsura, K. (2008)
 Simulation and estimation of the Neyman-Scott type spatial cluster models.
 \emph{Computer Science Monographs} \bold{34}, 1-44.
 The Institute of Statistical Mathematics, Tokyo.
 \url{https://www.ism.ac.jp/editsec/csm/}

Tanaka, U., Ogata, Y. and Stoyan, D. (2008)
 Parameter estimation and model selection for Neyman-Scott point processes.
 \emph{Biometrical Journal} \bold{50}, 43-57.
}

\keyword{ package }

