% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{beard_wide}
\alias{beard_wide}
\title{Beard descriptions}
\format{
A data frame with 8 rows and 24 columns:
\itemize{
\item rows are the types of beards;
\item columns are the assessors' opinions.
}
}
\source{
Applied mathematics department, Institut Agro Rennes-Angers
}
\usage{
beard_wide
}
\description{
These data refer to 8 types of beards. They come from a subset of the original "beard" dataset.
Each beard was evaluated by 62 assessors (except beard 8 which only had 60 evaluations).
}
\examples{
\donttest{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(beard_wide)

intro_beard <- "As a barber, you make
recommendations based on consumers comments.
Examples of consumers descriptions of beards
are as follows."
intro_beard <- gsub('\n', ' ', intro_beard) |>
stringr::str_squish()

res <- nail_sort(beard_wide[,1:5], name_size = 3,
stimulus_id = "beard", introduction = intro_beard,
measure = 'the description was')

res$dta_sort
cat(res$prompt_llm[[1]])
}
}
\keyword{datasets}
