test.batch.effects <- function(date.input = '2011-11-04', date.checked.output = '2011-11-04'){
	
	# go to test data directory
	path.to.input.files <- '../NanoStringNorm/extdata/input';
	path.to.output.files <- '../NanoStringNorm/extdata/output';

	# read input files
	x             <- read.table(paste(path.to.input.files, 'mRNA_TCDD_matrix.txt', sep = ''), sep = '\t', header = TRUE, as.is = TRUE);
	anno          <- read.table(paste(path.to.input.files, 'mRNA_TCDD_anno.txt', sep = ''), sep = '\t', header = TRUE, as.is = TRUE);
	trait         <- read.table(paste(path.to.input.files, 'mRNA_TCDD_strain_info.txt', sep = ''), sep = '\t', header = TRUE, as.is = TRUE);

	# read *checked output*
	checked.output.batch <- dget(file = paste(path.to.output.files, 'mRNA_TCDD_Batch_effects.txt', sep = ''));
	checked.output.sample.summary <- dget(file = paste(path.to.output.files, 'mRNA_TCDD_Sample_Summary.txt', sep = ''));

	# run function to get *test output* 
	test.output.batch      <- NanoStringNorm:::get.batch.effects(x, anno, sample.summary.stats = checked.output.sample.summary, traits = trait);

	### check1 - compare checked output == test output
	check1.1 <- checkEquals(checked.output.batch, test.output.batch);

	### check2 - check garbage input
	#check2.1 <- checkException(NanoStringNorm:::get.batch.effects(x, anno, traits = 'mean'));

	checks <- c(check1.1 = check1.1);
	if (!all(checks)) print(checks[checks == FALSE]);

	return(all(checks))

	}
