% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_probabilities.R
\name{conditional_probabilities}
\alias{conditional_probabilities}
\title{Summarise dyadic combination of elements}
\usage{
conditional_probabilities(netfacs.data)
}
\arguments{
\item{netfacs.data}{An object of class \code{\link{netfacs}} or
\code{\link{netfacs_multiple}}}
}
\value{
A summary \code{\link[tibble:tibble]{tibble}}
}
\description{
For all dyadic combinations that appear in the test dataset, this function
returns the probability of A occurring (P(A)), the probability of B occurring
(P(B)), the probability of A and B occurring simultaneously (P(AandB)) and, the
probability of A given B (P(A|B)).
}
\examples{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 50,
  combination.size = 2
)

conditional_probabilities(angry.face)
}
\seealso{
\code{\link{network_conditional}}
}
