% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{turtles2spdf}
\alias{turtles2spdf}
\alias{turtles2spdf,agentMatrix-method}
\title{From agentMatrix to SpatialPointsDataFrame}
\usage{
turtles2spdf(turtles)

\S4method{turtles2spdf}{agentMatrix}(turtles)
}
\arguments{
\item{turtles}{AgentMatrix object representing the moving agents.}
}
\value{
SpatialPointsDataFrame object representing the moving agents
       (coordinates and data)
        as contained in \code{turtles}.
}
\description{
Convert an agentMatrix object into a SpatialPointsDataFrame object.
}
\examples{
t1 <- createTurtles(n = 10, coords = cbind(xcor = 1:10, ycor = 1:10))
sp1 <- turtles2spdf(turtles = t1)


}
\author{
Sarah Bauduin
}
