% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\docType{methods}
\name{stackWorlds}
\alias{stackWorlds}
\alias{stackWorlds,worldMatrix-method}
\title{Stack worlds}
\usage{
stackWorlds(...)

\S4method{stackWorlds}{worldMatrix}(...)
}
\arguments{
\item{...}{worldMatrix objects.}
}
\value{
worldArray object.
}
\description{
Stack multiple worldMatrix into a worldArray.
}
\details{
The worldMatrix objects must all have the same extents.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 1:25)
w2 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 25:1)
w3 <- stackWorlds(w1, w2)
plot(w3)

}
\author{
Sarah Bauduin
}
