% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{NLany}
\alias{NLany}
\alias{any}
\alias{NLany,matrix-method}
\title{Any agents?}
\usage{
NLany(agents)

\S4method{NLany}{matrix}(agents)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}
}
\value{
Logical. \code{TRUE} if there is at least one patch or one turtle in the
        \code{agents}, \code{FALSE} otherwise.
}
\description{
Report \code{TRUE} if \code{agents} is non empty, report \code{FALSE} otherwise.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
p1 <- noPatches()
p2 <- patch(w1, 0, 0)
NLany(p1)
NLany(p2)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
t2 <- noTurtles()
NLany(t1)
NLany(t2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#any}
}
\author{
Sarah Bauduin
}
