% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\docType{methods}
\name{patches}
\alias{patches}
\alias{patches,worldNLR-method}
\title{All the \code{patches} in a \code{world}}
\usage{
patches(world)

\S4method{patches}{worldNLR}(world)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second column
        \code{pycor} representing the \code{patches} coordinates. The order of the \code{patches}
        follows the order of the cells numbers as defined for a \code{Raster*} object.
}
\description{
Report the coordinates of all the \code{patches} in the \code{world}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
allPatches <- patches(world = w1)
NLcount(allPatches) # 100 patches

}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patches}
}
\author{
Sarah Bauduin
}
