% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hypergeometric.R
\name{Hypergeometric.test}
\alias{Hypergeometric.test}
\title{Hypergeometric.test}
\usage{
Hypergeometric.test(
  success,
  universe_success,
  universe_failure,
  size_collected,
  lower.tail = FALSE
)
}
\arguments{
\item{success}{Is the number of elements in the overlap of the sets.}

\item{universe_success}{Is the number of elements of the set of interest.}

\item{universe_failure}{Is the number of elements of the set of the other set.}

\item{size_collected}{The total of elements in the universe}

\item{lower.tail}{Should the test be calculated on the lower tail? (Hypothesis test is lower than)}
}
\value{
the p-value for the hypergeometric test.
}
\description{
Calculates the significance of an overlap of two sets using an hypergeometric test.
   It is a wrapper of the `phyper` function.
}
\examples{
require(magrittr)
s = 10; S = 15; f = 10; T = 30
Hypergeometric.test(success = s,
universe_success = S,
universe_failure = f,
size_collected = T
)
}
