% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeBlockNetworkChange.R
\name{MakeBlockNetworkChange}
\alias{MakeBlockNetworkChange}
\title{Build a synthetic block-structured temporal data with breaks}
\usage{
MakeBlockNetworkChange(n = 10, break.point = 0.5, base.prob = 0.05,
  block.prob = 0.5, shape = 1, T = 40, break.point1 = 0.25,
  break.point2 = 0.75, type = "merge")
}
\arguments{
\item{n}{The number of nodes within a block. The total number of nodes is n*block.number.}

\item{break.point}{The point of break. 0 indicates the beginning, 0.5 indicates the middle,
and 1 indicates the end.}

\item{base.prob}{The probability of link among non-block members.}

\item{block.prob}{The probability of link among within-block members.}

\item{shape}{The speed of breaks.
The larger shape is, the faster the transition is. shape > 0 and shape < 8.}

\item{T}{The length of time.}

\item{break.point1}{The point of the first break in "merge-split" or "split-merge". Any number between 0 and 0.5 can be chosen.
For example, 0 indicates #' the beginning, 0.25 indicates the 1/4th point, and 0.5 indicates the half point.}

\item{break.point2}{The point of the second breakin "merge-split" or "split-merge". Any number between 0.5 and 1 can be chosen.
For example, 0.5 indicates the beginning, 0.75 indicates the 3/4th point, and 1 indicates the end point.}

\item{type}{The type of network changes. Options are "constant", "merge", "split",
"merge-split", "split-merge." If "constant" is chosen, the number of breaks is zero.
If "merge" or "split" is chosen, the number of breaks is one.
If either "merge-split" or "split-merge" is chosen, the number of breaks is two.}
}
\value{
output  An output of \code{MakeBlockNetworkChange} contains a symmetric block-structured temporal network data set with breaks.
}
\description{
MakeBlockNetworkChange generates a block-structured temporal data with breaks.
}
