% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{threshold}
\alias{threshold}
\title{Threshold Filter}
\usage{
threshold(data, a, thresh = c("alpha", "adaptive", "bonferroni", "FDR",
  "proportional"), n = nrow(data), normal = FALSE, na.data = c("pairwise",
  "listwise", "fiml", "none"))
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{a}{When thresh = "alpha", "adaptive", and "bonferroni" an alpha threshold is applied (defaults to \strong{.05}).
For "adaptive", beta (Type II error) is set to \strong{a*5} for a medium effect size (\emph{r} = \strong{.3}).
When thresh = "FDR", a q-value threshold is applied (defaults to \strong{.10}).
When thresh = "proportional", a density threshold is applied (defaults to \strong{.15})}

\item{thresh}{Sets threshold. Defaults to "alpha".
Set to any value 0> \emph{r} >1 to retain values greater than set value,
"adaptive" for an adapative alpha based on sample size (Perez & Pericchi, 2014),
"bonferroni" for the bonferroni correction on alpha,
"FDR" for local false discovery rate,
and "proportional" for a fixed density of edges (keeps strongest correlations within density)}

\item{n}{Number of participants in sample.
Defaults to the number of rows in the data.
If input is a correlation matrix, then n \strong{must} be set}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
If normal is TRUE, then "pairwise" is used.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}
}
\value{
Returns a list containing a filtered adjacency matrix (A) and the critical r value (r.cv)
}
\description{
Filters the network based on an r-value, alpha, adaptive alpha (see Perez & Pericchi, 2014),
bonferroni, false-discovery rate (FDR, \emph{fdrtool} package), or proportional density (fixed number of edges) value
}
\examples{
threshnet<-threshold(neoOpen)

alphanet<-threshold(neoOpen, thresh = "alpha", a = .05)

bonnet<-threshold(neoOpen, thresh = "bonferroni", a = .05)

FDRnet<-threshold(neoOpen, thresh = "FDR", a = .10)

propnet<-threshold(neoOpen, thresh = "proportional", a = .15)
}
\references{
Perez, M. E., & Pericchi, L. R. (2014).
Changing statistical significance with the amount of information: The adaptive \emph{a} significance level.
\emph{Statistics & Probability Letters}, \emph{85}, 20-24.

Strimmer, K. (2008).
fdrtool: A versatile R package for estimating local and tail area-based false discovery rates.
\emph{Bioinformatics}, \emph{24}(12), 1461-1462.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
