% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp.rep.R
\name{resp.rep}
\alias{resp.rep}
\title{Repeated Responses Check}
\usage{
resp.rep(data, scale.lens = NULL, max.val, reverse = NULL,
  freq.prop = 0.8)
}
\arguments{
\item{data}{A dataset}

\item{scale.lens}{The number of items for each scale in the data.
A vector indicating the length for each scale to be checked in the data}

\item{max.val}{Maximum value for data (or scales).
If scales have different maximum values, then a vector must be
input with each scale's maximum value (see examples)}

\item{reverse}{Reverse scored responses.
If responses have not yet reversed, then do not reverse them.
If responses have been reversed, then a vector indicating
which responses have been reverse-scored should be input (see examples).
Can be TRUE/FALSE or 1/0 (reversed/not reversed)}

\item{freq.prop}{Frequency proportion of the response values.
Allows the researcher to determine the maximum frequency proportion
of a certain response value is suspicious.
The default is set to \code{.80} (or 80 percent responses are a single value)}
}
\value{
Returns a matrix when \code{scale.lens = NULL} and a
list with elements corresponding to the order of scales. In general,
the output contains potential bad cases that should be further
inspected by the researcher.
}
\description{
Screens data to identify potential cases of repeated responding.
The function is based on two criteria: no variance (i.e., a standard
deviation of zero for given responses)and frequency proportion of the 
response values (which is set by \code{freq.prop}). Note that these
criteria are highly related. Additional criteria will be added in 
the future.
}
\details{
If a case is returned, then it does not mean that it is a bad case.
Researchers should thoroughly inspect each case that is returned.
A general guideline is that if a participant responded with all middle
values (e.g., all 3's on a 5-point Likert scale), then they should be
dropped. Note that a participant who responds with all maximum or
minimum values may be a real case or a bad case. It is up to the
researcher to decide and justify why or why not a case is kept.
}
\examples{
#Re-reverse responses
rev.vec <- c(TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,TRUE,FALSE,TRUE,FALSE,
TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,TRUE,FALSE,TRUE,
FALSE,FALSE,TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,TRUE,FALSE,TRUE,
FALSE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE)

#Maximum value (5-point Likert scale)
mv.vec <- 5

#Repeated responses check
resp.rep(neoOpen, reverse = rev.vec, max.val = mv.vec)

#Example with multiple scales

#Facet scale lengths of NEO-PI-3 Openness to Experience
s.len <- c(8, 8, 8, 8, 8, 8)

#Maximum values
mv.vec <- c(5, 5, 5, 5, 5, 5)

#Re-reverse responses
rev.vec <- c(TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,TRUE,FALSE,TRUE,FALSE,
TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,TRUE,FALSE,TRUE,
FALSE,FALSE,TRUE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,TRUE,FALSE,TRUE,
FALSE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE)

#Repeated responses check
resp.rep(neoOpen, scale.lens = s.len, max.val = mv.vec, reverse = rev.vec)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
