% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingdata.R
\name{spatialgraphlist}
\alias{spatialgraphlist}
\title{spatialgraphlist}
\usage{
spatialgraphlist(S, Z, isotropic = TRUE, stationary = TRUE, ...)
}
\arguments{
\item{S}{A list of spatial locations, where each element of the list is:
\itemize{
\item An \verb{n x d} matrix when locations are fixed across replicates in a given data set, where \code{n} is the number
of spatial locations and \code{d} is the spatial dimension (typically \code{d=2}).
\item A list of \verb{n_i x d} matrices when locations vary across replicates, where each matrix
corresponds to the spatial locations of a single replicate.
}}

\item{Z}{A list of spatial data, where each element of the list is:
\itemize{
\item An \verb{n x m} matrix when locations are fixed, where \code{m} is the number of replicates.
\item A list of \code{n_i} vectors when locations vary across replicates, where each vector
corresponds to the data for a single replicate.
}}

\item{isotropic}{Logical. If \code{TRUE}, edge features store the spatial distance (magnitude)
between nodes. If \code{FALSE}, the spatial displacement or spatial location is stored, depending
on the value of \code{stationary}.}

\item{stationary}{Logical. If \code{TRUE}, edge features store the spatial displacement
(vector difference) between nodes, capturing both magnitude and direction. If \code{FALSE},
edge features include the full spatial locations of both nodes.}

\item{...}{Additional keyword arguments from the Julia function \href{https://msainsburydale.github.io/NeuralEstimators.jl/dev/API/utility/#NeuralEstimators.adjacencymatrix}{\code{adjacencymatrix()}}
determine the neighborhood of each node, with the default being a randomly
selected set of \code{k=30} neighbors within a radius of \code{r=0.15} units.}
}
\value{
A list of \code{GNNGraph} objects stored as a \code{JuliaProxy} object; this object can be indexed in the usual manner (e.g., using \code{[[}), and converted to an R list using a combination of indexing and \code{lapply}.
}
\description{
Constructs a list of graph objects for use in a graph neural network.
}
\details{
Additional keyword arguments from the Julia function
\href{https://msainsburydale.github.io/NeuralEstimators.jl/dev/API/utility/#NeuralEstimators.adjacencymatrix}{\code{adjacencymatrix()}}
determine the neighborhood of each node, with the default being a randomly selected set of \code{k=30} neighbors within a radius of \code{r=0.15} units.
}
\examples{
\dontrun{
library("NeuralEstimators")

# Number of data sets, number of replicates in each data set, and spatial dimension
K <- 15
m <- 5
d <- 2

# Spatial locations fixed for all replicates within a given data set
n <- 100
S <- lapply(1:K, function(k) matrix(runif(n * d), n, d))
Z <- lapply(1:K, function(k) runif(n))
g <- spatialgraphlist(S, Z)

# Spatial locations varying between replicates within a given data set
S <- lapply(1:K, function(k) {
  lapply(1:m, function(i) {
    ni <- sample(50:100, 1)       # Randomly generate the number of locations for each replicate
    matrix(runif(ni * d), ni, d)  # Generate the spatial locations
  })
})
Z <- lapply(1:K, function(k) {
  lapply(1:m, function(i) {
    n <- nrow(S[[k]][[i]])
    runif(n)  
  })
})
g <- spatialgraphlist(S, Z)
}
}
\seealso{
\code{\link[=spatialgraph]{spatialgraph()}} for the non-vectorised version of this function.
}
