% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActFunc.R
\name{ActFunc}
\alias{ActFunc}
\title{Activation function of neuron}
\usage{
ActFunc(type = "sigmoid", ...)
}
\arguments{
\item{type}{\code{character} name of the activation function}

\item{...}{extra arguments needed to calculate the functions}
}
\value{
\code{numeric} output of the neuron
}
\description{
Evaluate activation function of a neuron
}
\examples{
# Return the sigmoid activation function of a neuron
ActivationFunction <- ActFunc("sigmoid")
# Return the tanh activation function of a neuron
ActivationFunction <- ActFunc("tanh")
# Return the activation function of several layers of neurons
actfuncs <- c("linear","sigmoid","linear")
ActivationFunctions <- sapply(actfuncs, ActFunc)
}
