% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombineSens.R
\name{CombineSens}
\alias{CombineSens}
\title{Sensitivity analysis plot over time of the data}
\usage{
CombineSens(object, comb_type = "mean")
}
\arguments{
\item{object}{\code{SensMLP} object generated by \code{\link[NeuralSens]{SensAnalysisMLP}}
with several outputs (classification MLP)}

\item{comb_type}{Function to combine the matrixes of the \code{raw_sens} component of \code{object}.
It can be "mean", "median" or "sqmean". It can also be a function to combine the rows of the matrixes}
}
\value{
\code{SensMLP} object with the sensitivities combined
}
\description{
Plot of sensitivity of the neural network output respect
to the inputs over the time variable from the data provided
}
\examples{
\donttest{
fdata <- iris
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata)[1:ncol(fdata)-1], collapse = " + ")
form <- formula(paste(names(fdata)[5], form, sep = " ~ "))

set.seed(150)
mod <- nnet::nnet(form,
                  data = fdata,
                  linear.output = TRUE,
                  size = hidden_neurons,
                  decay = decay,
                  maxit = iters)
# mod should be a neural network classification model
sens <- SensAnalysisMLP(mod, trData = fdata, output_name = 'Species')
combinesens <- CombineSens(sens, "sqmean")
}
}
