#' @name NiLeDAM
#' @aliases NiLeDAM NiLeDAM-package
#' @docType package
#' @title Monazite Dating for the 'NiLeDAM' Team
#' 
#' @description 
#' The aim here is to provide facilities to date monazite using electron microprobe
#' analysis (EPMA). More precisely, the 'NiLeDAM' package has three main features:
#' \itemize{
#'    \item \strong{ages calculation} from a set of analyses of the triplets (U,Th,Pb)
#'          contents and corresponding errors, it calculates the age of each analytic
#'          point by solving Equation (1) of Montel \emph{et al.} (1996)
#'    \item \strong{common age(s) estimation} from these results, it estimates the common
#'          age(s) under the assumption that the analyses come from a given number of age
#'          populations and test for this assumption (\eqn{\chi^2}{chi2}-test) 
#'    \item \strong{number of populations estimation} from the calculated ages, it estimates
#'    the most probable number of age populations from which the analyses come.
#' }
#' 
#' The package contains two main functions: \code{\link{calculateAges}()}, that 
#' calculate the ages and \code{\link{tests}()}, that test for the number of age
#' populations.
#'
#' An example is provided with the data \code{\link{srilanka}}, which can be run
#' using \command{demo(srilanka)}.
#' 
#' @author Aurélie Mercadié, \email{aurelie.mercadie@@inrae.fr}
#' @author Jean-Marc Montel, \email{jean-marc.montel@@ensg.inpl-nancy.fr}
#' @author Nathalie Vialaneix, \email{nathalie.vialaneix@@inrae.fr}
#' 
#' \strong{Maintainer}: Nathalie Vialaneix
#' 
#' @references Montel J.M., Foret S., Veschambre M., Nicollet C., Provost A. (1996) Electron
#' microprobe dating of monazite. \emph{Chemical Geology}, \bold{131}, 37--53.
#' 
#' @examples
#' \dontrun{demo(srilanka)}
#' 
#' @keywords htest aplot univar datasets
NULL