% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicCF.R
\name{dynamicCF}
\alias{dynamicCF}
\alias{dynamicCF.default}
\alias{dynamicCF.formula}
\title{Dynamic Classification Filter}
\usage{
\method{dynamicCF}{formula}(formula, data, ...)

\method{dynamicCF}{default}(x, nfolds = 10, consensus = FALSE, m = 3,
  classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{nfolds}{Number of folds for the cross voting scheme.}

\item{consensus}{If set to \code{TRUE}, consensus voting scheme is applied. Otherwise (default),
majority scheme is used.}

\item{m}{Number of classifiers to make up the ensemble. It must range between 1 and 9.}

\item{classColumn}{Positive integer indicating the column which contains the (factor of) classes.
By default, the last column is considered.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} is a factor containing the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Ensemble-based filter for removing label noise from a dataset as a
preprocessing step of classification. For more information, see 'Details' and
'References' sections.
}
\details{
\code{dynamicCF} (Garcia et al., 2012) follows the same approach as \code{\link{EF}}, but the ensemble of classifiers
is not fixed beforehand. Namely, \code{dynamicCF} trains 9 well-known classifiers in the
dataset to be filtered, and selects for the ensemble those with the \code{m} best predictions.
Then, a \code{nfolds}-folds cross voting scheme is applied, with consensus or majority strategies
depending on parameter \code{consensus}.

The nine (standard) classifiers handled by \code{dynamicCF} are SVM, 3-KNN, 5-KNN, 9-KNN, CART, C4.5,
Random Forest, Naive Bayes and Multilayer Perceptron Neural Network.
}
\examples{
# Next example is not run in order to save time
\dontrun{
data(iris)
trainData <- iris[c(1:20,51:70,101:120),]
# We fix a seed since there exists a random partition for the ensemble
set.seed(1)
out <- dynamicCF(Species~Petal.Length + Sepal.Length, data = trainData, nfolds = 5, m = 3)
summary(out, explicit = TRUE)
identical(out$cleanData, trainData[setdiff(1:nrow(trainData),out$remIdx),])
}
}
\references{
Garcia L. P. F., Lorena A. C., Carvalho A. C. (2012, October): A study on class
noise detection and elimination. In \emph{Brazilian Symposium on Neural Networks (SBRN)}, pp. 13-18, IEEE.
}

