% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangled_rda.R
\name{wrangled_rda}
\alias{wrangled_rda}
\title{Download Open Case Study Wrangled Data - RDAs}
\usage{
wrangled_rda(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to pull data from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-rural-and-urban-obesity

ocs-bp-air-pollution

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-RTC-analysis

ocs-bp-youth-disconnection

ocs-bp-youth-mental-health

ocs-bp-school-shootings-dashboard

ocs-bp-co2-emissions

ocs-bp-diet}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved to.}
}
\value{
If download is successful, the path to the downloaded data folder is
returned. Otherwise the appropriate error message is returned.
}
\description{
Download the specified case study wrangled data to use as you follow along the case study.
}
\details{
This function downloads the Open Case Study wrangled data from GitHub
and saves it in a new 'OCSdata/data/wrangled/' folder in
the specified directory. This makes it so all the wrangled data
are easily available in a local folder. The data will be in .rda format.
}
\examples{
tmp = tempfile()
dir.create(tmp)
wrangled_rda('ocs-bp-opioid-rural-urban', outpath = tmp)

}
