% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silicaBerk-data.R
\docType{data}
\name{silicaBerk}
\alias{silicaBerk}
\title{Nanoindentation measurements data}
\format{
The data frame contains two columns:
\describe{
  \item{Depth}{nanoindentation depth, in nanometers.}
  \item{Load}{load, in milinewtons.}
}
}
\source{
Czech Metrology Institute, Brno, Czech Republic.
}
\usage{
silicaBerk
}
\description{
Load and depth measured with Berkovich diamond tip on fused silica material.
 Data contains only unloading part of indentation curve. The relationship between \emph{Load} (\emph{F}) and \emph{Depth} (\emph{h}) is given by equation
 \eqn{F = \alpha (h - h_p)^{m}}, where  \emph{h_p} is permanent indentation depth after
 removal of the load, \eqn{\alpha} is fitting constant related to the indenter geometry and
 power law exponent \emph{m} should be from (1,2) interval.
}
\examples{
attach(silicaBerk)
plot(Depth, Load, main = 'Graph of nanoindentation data', xlab = 'Depth (nm)', ylab = 'Load (mN)',
col = 'darkgreen', cex = 1)
}
\keyword{datasets}
