% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.OHPL.R
\name{predict.OHPL}
\alias{predict.OHPL}
\title{Make Predictions Based on the Fitted OHPL Model}
\usage{
\method{predict}{OHPL}(object, newx, ncomp = NULL, type = "response", ...)
}
\arguments{
\item{object}{An object of class \code{OHPL}
fitted by \code{\link{OHPL}}.}

\item{newx}{Predictor matrix of the new data.}

\item{ncomp}{Optimal number of components.
If is \code{NULL}, the optimal number of components
stored in the model object will be used.}

\item{type}{Prediction type.}

\item{...}{Additional parameters.}
}
\value{
Numeric matrix of the predicted values.
}
\description{
Make predictions on new data by an OHPL model object.
}
\examples{
# generate simulation data
dat = OHPL.sim(
  n = 100, p = 100, rho = 0.8,
  coef = rep(1, 10), snr = 3, p.train = 0.5,
  seed = 1010)

# split training and test set
x = dat$x.tr
y = dat$y.tr
x.test = dat$x.te
y.test = dat$y.te

# fit the OHPL model
fit = OHPL(x, y, maxcomp = 3, gamma = 0.5, G = 10, type = "max")
# make predictions
y.pred = predict(fit, x.test)
y.pred
}

