% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus600.r
\name{opiInitialise_for_O600}
\alias{opiInitialise_for_O600}
\title{Implementation of opiInitialise for the O600 machine.}
\arguments{
\item{ipAddress}{The IP address of the O600 as a string.}

\item{eye}{Either "left" or "right".}

\item{pupilTracking}{TRUE to turn on IR illumination and set pupil
black level (which happens at the first stimulus presentation).}

\item{pulsar}{TRUE for pulsar stimulus, FALSE for size III white-on-white.}

\item{eyeControl}{One of

\if{html}{\out{<div class="sourceCode">}}\preformatted{* 0 is off
* 1 is eye blink
* 2 is eye blink, forehead rest, fixation control
* 3 is eye blink, forehead rest, fixation control, fast eye movements
}\if{html}{\out{</div>}}}
}
\description{
This is for internal use only. Use \code{\link[=opiInitialise]{opiInitialise()}} with
these Arguments and you will get the Value back.
}
\details{
The default
background and stimulus setup is to white-on-white perimetry.

Uses port 50000 on the O600.
}
\examples{
\dontrun{
  # Set up the O600
  chooseOpi("O600")
  opiInitialize(ip="192.168.1.7", eye = "left")
}
}
