% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAIA.r
\name{opiSetup_for_MAIA}
\alias{opiSetup_for_MAIA}
\title{Implementation of opiSetup for the MAIA machine.}
\arguments{
\item{settings}{is a list that could contain:
\itemize{
\item \code{fixation} \code{list(x,y,t,c)} where
\itemize{
\item \code{x} is one of 0, +-2.4, +-4.8 degrees.
\item \code{y} is one of 0, +-2.4, +-4.8 degrees.
\item \code{t} is 0 for big circle off, 1 for big circle on.
\item \code{p} power integer in range 0..1023.
}
\item \code{bg} which is 0 for no background and other for some background
\item \code{tracking} which is 0 for no tracking and other for some tracking
\item \code{open} If present, will send OPI-OPEN to MAIA and look for prl, onh, fundus image
}}
}
\value{
A list containing
* \code{err} which is \code{NULL} for success
* \code{message} for some messages from MAIA (probably "0")
For \code{open} list might (but might not) contain:
\itemize{
\item \code{prl} A pair giving the (x,y) in degrees of the Preferred Retinal
Locus detected in the initial alignment.
\item \code{onh} a pair giving the (x,y) in degrees of the ONH as selected by the user.
\item \code{image} raw bytes being the JPEG compressed infra-red image acquired during alignment.
}
}
\description{
This is for internal use only. Use \code{\link[=opiSetup]{opiSetup()}} with
these Arguments and you will get the Value back.
}
\details{
Note that corner locations are missing, so both \code{x} and \code{y} cannot be +-4.8.
}
