#' @title Mobile Health.
#' @description The MHEALTH (Mobile Health) dataset benchmarks techniques for human behavior analysis based on multimodal body sensing. 
#' @details Recordings of body motion for ten volunteers
#' performing several physical activities. Sensors are placed on the subject's chest, right wrist 
#' and left ankle are used to measure the motion experienced by diverse body parts, namely, 
#' acceleration, rate of turn and magnetic field orientation. The sensor positioned on the chest 
#' also provides 2-lead ECG measurements, which can be potentially used for basic heart monitoring, 
#' checking for various arrhythmias or looking at the effects of exercise on the ECG.
#'
#' @format A time series data with multi-classes and multi-features. 
#' \describe{
#'   #Activities: 12 
#'   
#'   #Sensor devices: 3 
#'   
#'   #Subjects: 10 
#'   
#'   The activity set is listed in the following: 
#'   
#'   L1: Standing still (1 min) 
#'   
#'   L2: Sitting and relaxing (1 min) 
#'   
#'   L3: Lying down (1 min) 
#'   
#'   L4: Walking (1 min) 
#'   
#'   L5: Climbing stairs (1 min) 
#'   
#'   L6: Waist bends forward (20x) 
#'   
#'   L7: Frontal elevation of arms (20x) 
#'   
#'   L8: Knees bending (crouching) (20x) 
#'   
#'   L9: Cycling (1 min) 
#'   
#'   L10: Jogging (1 min) 
#'   
#'   L11: Running (1 min) 
#'   
#'   L12: Jump front & back (20x) 
#'   
#'   The meaning of each column is detailed next: 
#'   
#'   Column 1: acceleration from the chest sensor (X axis) 
#'   
#'   Column 2: acceleration from the chest sensor (Y axis) 
#'   
#'   Column 3: acceleration from the chest sensor (Z axis) 
#'   
#'   Column 4: electrocardiogram signal (lead 1) 
#'   
#'   Column 5: electrocardiogram signal (lead 2) 
#'   
#'   Column 6: acceleration from the left-ankle sensor (X axis) 
#'   
#'   Column 7: acceleration from the left-ankle sensor (Y axis) 
#'   
#'   Column 8: acceleration from the left-ankle sensor (Z axis) 
#'   
#'   Column 9: gyro from the left-ankle sensor (X axis) 
#'   
#'   Column 10: gyro from the left-ankle sensor (Y axis) 
#'   
#'   Column 11: gyro from the left-ankle sensor (Z axis) 
#'   
#'   Column 12: magnetometer from the left-ankle sensor (X axis) 
#'   
#'   Column 13: magnetometer from the left-ankle sensor (Y axis) 
#'   
#'   Column 14: magnetometer from the left-ankle sensor (Z axis) 
#'   
#'   Column 15: acceleration from the right-lower-arm sensor (X axis)
#'    
#'   Column 16: acceleration from the right-lower-arm sensor (Y axis) 
#'   
#'   Column 17: acceleration from the right-lower-arm sensor (Z axis) 
#'   
#'   Column 18: gyro from the right-lower-arm sensor (X axis) 
#'   
#'   Column 19: gyro from the right-lower-arm sensor (Y axis) 
#'   
#'   Column 20: gyro from the right-lower-arm sensor (Z axis) 
#'   
#'   Column 21: magnetometer from the right-lower-arm sensor (X axis) 
#'   
#'   Column 22: magnetometer from the right-lower-arm sensor (Y axis)
#'    
#'   Column 23: magnetometer from the right-lower-arm sensor (Z axis) 
#'   
#'   Column 24: Label (0 for the null class) 
#'   
#'   In this dataset, for a simple example displaying, only subject 1-5 and feature 12 (magnetometer 
#'   from the left-ankle sensor (X axis)) are used, and the dataset is reformated to binary class. 
#'   Class 11 is set as positive, others as negative. The time series sequences length uses 30. Each 
#'   sequence occurs in one line.
#' }
#' 
#' @references Banos, O., Garcia, R., Holgado, J. A., Damas, M., Pomares, H., Rojas, I., Saez, A., Villalonga, C. 
#'             mHealthDroid: a novel framework for agile development of mobile health applications. 
#'             Proceedings of the 6th International Work-conference on Ambient Assisted Living an Active Ageing (IWAAL 2014), 
#'             Belfast, Northern Ireland, December 2-5, (2014).
#'             
#'             Banos, O., Villalonga, C., Garcia, R., Saez, A., Damas, M., Holgado, J. A., Lee, S., Pomares, H., Rojas, I. 
#'             Design, implementation and validation of a novel open framework for agile development of mobile health applications. 
#'             BioMedical Engineering OnLine, vol. 14, no. S2:S6, pp. 1-20 (2015).
#'             
#' @return mhealth: the dataset MHEALTH
#' @export Dataset_MHEALTH

Dataset_MHEALTH <- function(){
  mhealth <- local(get(load(url('https://github.com/lweicdsor/GSoC2017/raw/master/MHEALTH/Dataset_MHEALTH.rdata'))))
  return (mhealth)
  }