% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{RCO}
\alias{RCO}
\title{A function to compute Relative Concentration index (RCO)}
\usage{
RCO(x, a = NULL, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{a}{- a vector with areas of spatial units}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A matrix with relative concentration index
}
\description{
Relative concentration index measures the share
of urban space occupied by a group compared to another group.
The function can be used in two ways: by providing a vector with
spatial units' area or a geographic source (spatial object or
shape file) wich will be used to compute the area vector within
the function
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
ar <- area(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

RCO(x, a = ar)

RCO(x, spatobj = GreHSize)

RCO(x, folder = foldername, shape = shapename)
}
\references{
Massey D. S. and Denton N. A. (1988) \emph{
The dimensions of residential segregation}.
Social Forces 67(2),  pp. 281-315.
}
\seealso{
Intragroup concentration indices: \code{\link{Delta}},  \code{\link{ACO}}
}

